/*
 * XXXX 
 *
 * Fecha 08/05/2007
 * 
 *  
 */
 
package com.ejie.p06b.servlet;

import java.io.IOException;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejie.p06b.general.P06BConstantes;
import com.ejie.p06b.general.P06BPaginas;
import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.util.P06BFecha;
import com.ejie.p06b.util.P06BResources;
import com.ejie.p06b.xlnet.P06BPerfilUsuario;

import java.util.Date;
import n38c.exe.*;


/**
 *  Esta clase gestiona las peticiones HTTP de la aplicacin.
 */
public class P06BAccesoServlet extends P06BServlet 
{
	/**
     *  Inicializa variables globales
     *  @param  config   variable que se quiere inicializar.
     *  @throws ServletException si ocurre algn problema en la inicializacin.
     */
    public void init (ServletConfig config) throws ServletException 
	{
        super.init (config);
    }

    /**
     *  Representa la operacin de peticin HTTP get
     *  @param  request     Peticin del cliente
     *  @param  response    Respuesta al cliente
     *  @throws ServletException
     *  @throws IOException
     */
    public void doGet (HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException 
	{
        doPost(request, response);
    }

    /**
     *  Representa la operacin de peticin HTTP post
     *  @param  request     Peticin del cliente
     *  @param  response    Respuesta al cliente
     *  @throws ServletException 
     *  @throws IOException
     */

	public void doPost (HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
			N38API   n38API   = null;
			String usuario = "";
			String horaActual = "";
			String fechaActualStr = "";
			String horaActual2 = "";
			String fechaActualStr2 = "";
			try 
			{
				// Creo un objeto N38API y lo meto en la sesion si no existe.
				// Es necesario crear el objeto para poder utilizar el API de XL-Net-s.
				n38API = (N38API)getObjetoSesion(P06BConstantes.P06B_N38API, request, response);			
				if (n38API==null)
				{
					P06BLog.send(0,this,"Objeto N38 es null");
					n38API = new N38API(request);
				     	setObjetoSesion (P06BConstantes.P06B_N38API, n38API, request, response);				
				}
			
				P06BLog.send(2,this, "n38API="+(n38API==null));
				P06BPerfilUsuario lPerfil = new P06BPerfilUsuario("");
				P06BLog.send(2,this, "lPerfil="+(lPerfil==null));
				lPerfil.cargarPerfil(request, n38API);
				P06BLog.send(2,this, "lPerfil="+(lPerfil==null));
				setObjetoSesion (P06BConstantes.P06B_VAR_PERFIL_USUARIO, lPerfil, request, response);
				P06BLog.send(2,this, "lPerfil="+(lPerfil==null));
				marcarSesion(request, response);
				
				P06BLog.send(2,this, P06BConstantes.P06B_RES_ETIQUETAS);

				// Gestin del idioma
				P06BResources resErrores = new P06BResources (lPerfil.getLocale(),P06BConstantes.P06B_RES_ERRORES);
				P06BResources resEtiquetas = new P06BResources (lPerfil.getLocale(),P06BConstantes.P06B_RES_ETIQUETAS);
				
				P06BLog.send(2,this, "resEtiquetas="+(resEtiquetas==null));
				setObjetoSesion (P06BConstantes.P06B_RES_SES_ERRORES, resErrores, request, response);
				setObjetoSesion (P06BConstantes.P06B_RES_SES_ETIQUETAS, resEtiquetas, request, response);
	            setObjetoSesion (P06BConstantes.P06B_MODO_ACCESO, "V", request, response);
	            setObjetoSesion (P06BConstantes.P06B_DNI, lPerfil.getDNI(), request, response);
	
				fechaActualStr = P06BFecha.getFechaFormateada(new Date(),lPerfil.getLocale());
				horaActual = P06BFecha.getHoraCompleta(new Date());
				fechaActualStr = fechaActualStr + " " + horaActual;
				usuario = lPerfil.getIdUsuario();
				setObjetoSesion (P06BConstantes.P06B_FECHA_ACCESO,fechaActualStr,request,response);
				setObjetoSesion (P06BConstantes.P06B_USUARIO_ACCESO,usuario,request,response);
//				forward (request, response, P06BPaginas.P06B_JSP_PAGINA_PORTAL);
				forward (request, response, P06BPaginas.P06B_JSP_SERVLETATENCIONPETICIONESLISTADO);
			}catch (Exception e){
		      	manejarErrores (request, response, e);
		        return;
		    }
	}

    /**
     *  Obtiene informacin del servlet
     */
    public String getServletInfo () 
	{
        return "Servlet de acceso a la aplicacin P06B";
    }    
}